// $Id: CDimension.cpp,v 1.6 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CDimension.hpp"
using Exponent::MathTools::CDimension;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CDimension, CCountedObject);

//	===========================================================================
CDimension::CDimension(const long width, const long height) : m_width(width), m_height(height)
{
	EXPONENT_CLASS_CONSTRUCTION(CDimension);
}

//	===========================================================================
CDimension::CDimension(const CDimension &dimension) : m_width(0), m_height(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CDimension);
	this->setDimension(dimension);
}

//	===========================================================================
CDimension::~CDimension()
{
	EXPONENT_CLASS_DESTRUCTION(CDimension);
}

//	===========================================================================
CDimension &CDimension::operator = (const CDimension &dimension)
{
	m_width  = dimension.m_width;
	m_height = dimension.m_height;
	return *this;
}

//	===========================================================================
bool CDimension::operator == (const CDimension &dimension)
{
	return ((m_width == dimension.m_width) && (m_height == dimension.m_height));
}

//	===========================================================================
void CDimension::setDimension(const long width, const long height)
{
	m_height = height;
	m_width = width;
}

//	===========================================================================
void CDimension::setDimension(const CDimension &dimension)
{
	m_width  = dimension.m_width;
	m_height = dimension.m_height;
}

//	===========================================================================
void CDimension::setWidth(const long width)
{ 
	m_width = width; 
}

//	===========================================================================
void CDimension::setHeight(const long height) 
{ 
	m_height = height; 
}

//	===========================================================================
long CDimension::getWidth() const 
{ 
	return m_width; 
}

//	===========================================================================
long CDimension::getHeight() const 
{ 
	return m_height; 
}